Sub AddLandmark
  Dim dblX, dblY, objToolButton, blnLyrExists
  'Get a reference to the tool button object 
  Set objToolButton = ThisEvent.Object
  'Initialize blnLyrExists flag to False
  blnLyrExists = False
  'If Landmarks layer exists, set the blnLyrExists flag to true
  Dim objLyr
  For Each objLyr in Map.Layers
    If StrComp (objLyr.Name, "Landmarks", 1) = 0 Then
      blnLyrExists = True
      Exit For
    End If
  Next
  'If Landmarks layer does not exist: 
  'Notify the user, return the tool button to its original state, and exit.
  If Not blnLyrExists Then
    MsgBox "The Landmarks layer is not present in the current map.", vbExclamation, "Layer not present"
    objToolButton.Click
    Exit Sub
  End If
  'If the Landmarks layer does exist:
  'Get the coordinates of the map where the user clicked
  dblX = Map.PointerX
  dblY = Map.PointerY
  'Get a reference to the Landmarks Layer object
  Dim objLayer
  Set objLayer = Map.Layers("Landmarks")
  'If the layer can be made editable, make it editable
  If objLayer.CanEdit Then
    objLayer.Editable = True
    'Add a new tree (point feature) at the clicked location
    Call Map.AddFeatureXY(dblX,dblY)
    'Return the tool button to its original state
    objToolButton.Click
  End If
End Sub

Sub AddLandmarkByGPS
  Dim dblX, dblY, blnLyrExists, blnCanOpenGPS
  'Initialize blnLyrExists flag to False
  blnLyrExists = False
  'If Landmarks layer exists, set the blnLyrExists flag to true
  Dim objLyr
  For Each objLyr in Map.Layers
    If StrComp (objLyr.Name, "Landmarks", 1) = 0 Then
      blnLyrExists = True
      Exit For
    End If
  Next
  'If Landmarks layer does not exist: 
  'Notify the user and exit.
  If Not blnLyrExists Then
    MsgBox "The Landmarks layer is not present in the current map.", vbExclamation, "Layer not present"
    Exit Sub
  End If
  'If the Landmarks layer does exist:
  'If the GPS is not active, attempt to activate it
  If Not GPS.IsOpen Then
    blnCanOpenGPS = GPS.Open
    If blnCanOpenGPS Then
      MsgBox "The GPS has been activated.  Please wait until you are receiving an acceptable GPS position and then " &_
             "click or tap this tool again", vbInformation, "GPS Activated"
      Exit Sub
    Else
      MsgBox "The GPS cannot be activated.  Please check your cables and configuration options and try again",_
              vbExclamation, "Error Activating GPS"
      Exit Sub
    End If
  Else
    'If the current fix is not valid, notify the user and exit the subroutine
    If Not GPS.IsValidFix Then
      MsgBox "The GPS is not currently outputting a valid fix.  Please wait until you are receiving an acceptable GPS position and then " &_
             "click or tap this tool again", vbExclamation, "No Valid GPS Fix"
      Exit Sub
    End If
  End If
  'Get the coordinates of the GPS
  dblX = GPS.X
  dblY = GPS.Y
  'Get a reference to the Landmarks Layer object
  Dim objLayer
  Set objLayer = Map.Layers("Landmarks")
  'If the layer can be made editable, make it editable
  If objLayer.CanEdit Then
    objLayer.Editable = True
    'Add a new tree (point feature) at the clicked location
    Call Map.AddFeatureXY(dblX,dblY)
  End If
End Sub
Sub DemoMessage
msgbox "This tool button works.  WOOF!"
End Sub

Sub SummaryInfo
	MsgBox "The current version of ArcPad is " & _
         Application.Properties("ProductVersion") & vbCrLf & _
			  "The current map scale is 1:" & Map.Scale & vbCrLf & _
		    "There are " & Map.Layers.Count & _
 		    " layers in the current map."

	Dim strVectorLayers, strRasterLayers, strEditableLayers
	strVectorLayers = "The vector layers in the current map are "
	strRasterLayers = "The raster layers in the current map are "
	strEditableLayers = "The editable layers in the current map are "
	Dim objLyr
	For Each objLyr in Map.Layers
		If objLyr.LayerType = 0 Then   'Vector layer
			strVectorLayers = strVectorLayers & objLyr.Name & ", "
			If objLyr.Editable Then   'Editable layer.. only vector layers can be editable
				strEditableLayers = strEditableLayers & objLyr.Name & ", "
			End If
		ElseIf objLyr.LayerType = 1 Then  'Raster layer
			strRasterLayers = strRasterLayers & objLyr.Name & ", "
		End If
	Next
	MsgBox strVectorLayers & vbCrLf & _
				strRasterLayers & vbCrLf & _
				strEditableLayers
End Sub